import { DeviceInfoModule } from './internal/privateTypes';
import { AsyncHookResult, DeviceType, PowerState } from './internal/types';
export declare function getUniqueId(): string;
export declare function getInstanceId(): Promise<string>;
export declare function getInstanceIdSync(): string;
export declare function getSerialNumber(): Promise<string>;
export declare function getSerialNumberSync(): string;
export declare function getAndroidId(): Promise<string>;
export declare function getAndroidIdSync(): string;
export declare function getIpAddress(): Promise<string>;
export declare function getIpAddressSync(): string;
export declare function isCameraPresent(): Promise<boolean>;
export declare function isCameraPresentSync(): boolean;
export declare function getMacAddress(): Promise<string>;
export declare function getMacAddressSync(): string;
export declare function getDeviceId(): string;
export declare function getManufacturer(): Promise<string>;
export declare function getManufacturerSync(): string;
export declare function getModel(): string;
export declare function getBrand(): string;
export declare function getSystemName(): string;
export declare function getSystemVersion(): string;
export declare function getBuildId(): Promise<string>;
export declare function getBuildIdSync(): string;
export declare function getApiLevel(): Promise<number>;
export declare function getApiLevelSync(): number;
export declare function getBundleId(): string;
export declare function getInstallerPackageName(): Promise<string>;
export declare function getInstallerPackageNameSync(): string;
export declare function getApplicationName(): string;
export declare function getBuildNumber(): string;
export declare function getVersion(): string;
export declare function getReadableVersion(): string;
export declare function getDeviceName(): Promise<string>;
export declare function getDeviceNameSync(): string;
export declare function getUsedMemory(): Promise<number>;
export declare function getUsedMemorySync(): number;
export declare function getUserAgent(): Promise<string>;
export declare function getUserAgentSync(): string;
export declare function getFontScale(): Promise<number>;
export declare function getFontScaleSync(): number;
export declare function getBootloader(): Promise<string>;
export declare function getBootloaderSync(): string;
export declare function getDevice(): Promise<string>;
export declare function getDeviceSync(): string;
export declare function getDisplay(): Promise<string>;
export declare function getDisplaySync(): string;
export declare function getFingerprint(): Promise<string>;
export declare function getFingerprintSync(): string;
export declare function getHardware(): Promise<string>;
export declare function getHardwareSync(): string;
export declare function getHost(): Promise<string>;
export declare function getHostSync(): string;
export declare function getProduct(): Promise<string>;
export declare function getProductSync(): string;
export declare function getTags(): Promise<string>;
export declare function getTagsSync(): string;
export declare function getType(): Promise<string>;
export declare function getTypeSync(): string;
export declare function getBaseOs(): Promise<string>;
export declare function getBaseOsSync(): string;
export declare function getPreviewSdkInt(): Promise<number>;
export declare function getPreviewSdkIntSync(): number;
export declare function getSecurityPatch(): Promise<string>;
export declare function getSecurityPatchSync(): string;
export declare function getCodename(): Promise<string>;
export declare function getCodenameSync(): string;
export declare function getIncremental(): Promise<string>;
export declare function getIncrementalSync(): string;
export declare function isEmulator(): Promise<boolean>;
export declare function isEmulatorSync(): boolean;
export declare function isTablet(): boolean;
export declare function isPinOrFingerprintSet(): Promise<boolean>;
export declare function isPinOrFingerprintSetSync(): boolean;
export declare function hasNotch(): boolean;
export declare function getFirstInstallTime(): Promise<number>;
export declare function getFirstInstallTimeSync(): number;
export declare function getInstallReferrer(): Promise<string>;
export declare function getInstallReferrerSync(): string;
export declare function getLastUpdateTime(): Promise<number>;
export declare function getLastUpdateTimeSync(): number;
export declare function getPhoneNumber(): Promise<string>;
export declare function getPhoneNumberSync(): string;
export declare function getCarrier(): Promise<string>;
export declare function getCarrierSync(): string;
export declare function getTotalMemory(): Promise<number>;
export declare function getTotalMemorySync(): number;
export declare function getMaxMemory(): Promise<number>;
export declare function getMaxMemorySync(): number;
export declare function getTotalDiskCapacity(): Promise<number>;
export declare function getTotalDiskCapacitySync(): number;
export declare function getFreeDiskStorage(): Promise<number>;
export declare function getFreeDiskStorageSync(): number;
export declare function getBatteryLevel(): Promise<number>;
export declare function getBatteryLevelSync(): number;
export declare function getPowerState(): Promise<{}>;
export declare function getPowerStateSync(): {};
export declare function isBatteryCharging(): Promise<boolean>;
export declare function isBatteryChargingSync(): boolean;
export declare function isLandscape(): Promise<boolean>;
export declare function isLandscapeSync(): boolean;
export declare function isAirplaneMode(): Promise<boolean>;
export declare function isAirplaneModeSync(): boolean;
export declare function getDeviceType(): DeviceType;
export declare function getDeviceTypeSync(): DeviceType;
export declare function supportedAbis(): Promise<string[]>;
export declare function supportedAbisSync(): string[];
export declare function supported32BitAbis(): Promise<string[]>;
export declare function supported32BitAbisSync(): string[];
export declare function supported64BitAbis(): Promise<string[]>;
export declare function supported64BitAbisSync(): string[];
export declare function hasSystemFeature(feature: string): Promise<boolean>;
export declare function hasSystemFeatureSync(feature: string): boolean;
export declare function getSystemAvailableFeatures(): Promise<string[]>;
export declare function getSystemAvailableFeaturesSync(): string[];
export declare function isLocationEnabled(): Promise<boolean>;
export declare function isLocationEnabledSync(): boolean;
export declare function isHeadphonesConnected(): Promise<boolean>;
export declare function isHeadphonesConnectedSync(): boolean;
export declare function getAvailableLocationProviders(): Promise<import("./internal/types").LocationProviderInfo>;
export declare function getAvailableLocationProvidersSync(): import("./internal/types").LocationProviderInfo;
export declare function getDeviceToken(): Promise<string>;
export declare function useBatteryLevel(): number | null;
export declare function useBatteryLevelIsLow(): number | null;
export declare function usePowerState(): PowerState | {};
export declare function useFirstInstallTime(): AsyncHookResult<number>;
export declare function useDeviceName(): AsyncHookResult<string>;
export declare function useHasSystemFeature(feature: string): AsyncHookResult<boolean>;
export declare function useIsEmulator(): AsyncHookResult<boolean>;
declare const deviceInfoModule: DeviceInfoModule;
export default deviceInfoModule;
