export function defineMessages(msgs) {
    return msgs;
}
import { createFormattedComponent, createFormattedDateTimePartsComponent, } from './components/createFormattedComponent';
export { default as injectIntl, Provider as RawIntlProvider, Context as IntlContext, } from './components/injectIntl';
export { default as useIntl } from './components/useIntl';
export { default as IntlProvider, createIntl } from './components/provider';
// IMPORTANT: Explicit here to prevent api-extractor from outputing `import('./types').CustomFormatConfig`
export const FormattedDate = createFormattedComponent('formatDate');
export const FormattedTime = createFormattedComponent('formatTime');
export const FormattedNumber = createFormattedComponent('formatNumber');
export const FormattedList = createFormattedComponent('formatList');
export const FormattedDisplayName = createFormattedComponent('formatDisplayName');
export const FormattedDateParts = createFormattedDateTimePartsComponent('formatDate');
export const FormattedTimeParts = createFormattedDateTimePartsComponent('formatTime');
export { FormattedNumberParts } from './components/createFormattedComponent';
export { default as FormattedRelativeTime } from './components/relative';
export { default as FormattedPlural } from './components/plural';
export { default as FormattedMessage } from './components/message';
export { createIntlCache } from './utils';
export { ReactIntlError } from './error';
