export class ReactIntlError extends Error {
    constructor(code, message, exception) {
        super(`[React Intl Error ${code}] ${message} ${exception ? `\n${exception.stack}` : ''}`);
        this.code = code;
        if (typeof Error.captureStackTrace === 'function') {
            Error.captureStackTrace(this, ReactIntlError);
        }
    }
}
