"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _idbKeyval = require("idb-keyval");

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class WebStorage {
  constructor(storageType = 'idb') {
    _defineProperty(this, "storage", void 0);

    if (storageType === 'idb') {
      this.storage = {
        name: storageType,
        getItem: _idbKeyval.get,
        setItem: _idbKeyval.set,
        deleteItem: _idbKeyval.del,
        keys: _idbKeyval.keys,
        clear: _idbKeyval.clear
      };
    } else {
      const webStorage = storageType === 'local' ? window.localStorage : window.sessionStorage;
      this.storage = {
        name: storageType,
        getItem: webStorage.getItem.bind(webStorage),
        setItem: webStorage.setItem.bind(webStorage),
        deleteItem: webStorage.removeItem.bind(webStorage),
        keys: () => Object.keys(webStorage),
        clear: webStorage.clear.bind(webStorage)
      };
    }
  }

  async getSingle(key) {
    return this.storage.getItem(key);
  }

  async setSingle(key, value) {
    return this.storage.setItem(key, value);
  }

  async getMany(keys) {
    if (this.storage.name === 'idb') {
      return Promise.all(keys.map(key => this.storage.getItem(key))).then(readValues => readValues.reduce((values, currentValue, currentIndex) => {
        const key = keys[currentIndex];
        return _objectSpread({}, values, {
          [key]: currentValue
        });
      }, {}));
    }

    return keys.reduce((storageValues, key) => {
      return _objectSpread({}, storageValues, {
        [key]: this.storage.getItem(key)
      });
    }, {});
  }

  async setMany(values) {
    for (let keyValue of values) {
      const key = Object.getOwnPropertyNames(keyValue)[0];

      if (!key) {
        continue;
      }

      await this.storage.setItem(key, keyValue[key]);
    }
  }

  async removeSingle(key) {
    return this.storage.deleteItem(key);
  }

  async removeMany(keys) {
    if (this.storage.name === 'idb') {
      for (const key of keys) {
        await this.storage.deleteItem(key);
      }
    } else {
      await Promise.all(keys.map(k => this.storage.deleteItem(k)));
    }
  }

  async getKeys() {
    return this.storage.keys();
  }

  async dropStorage() {
    return this.storage.clear();
  }

}

var _default = WebStorage;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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