/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.buck.android.support.exopackage;

import android.content.Context;
import android.util.Log;
import com.facebook.buck.android.support.exopackage.SystemClassLoaderAdder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class ExopackageDexLoader {
    private static final String TAG = "ExopackageDexLoader";

    private ExopackageDexLoader() {
    }

    public static void loadExopackageJars(Context context) {
        File containingDirectory = new File("/data/local/tmp/exopackage/" + context.getPackageName() + "/secondary-dex");
        ArrayList<File> dexJars = new ArrayList<File>();
        HashSet<String> expectedOdexSet = new HashSet<String>();
        File[] files = containingDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.getName().equals("metadata.txt")) continue;
                if (!file.getName().endsWith(".dex.jar")) {
                    Log.w((String)TAG, (String)("Skipping unexpected file in exopackage directory: " + file.getName()));
                    continue;
                }
                dexJars.add(file);
                expectedOdexSet.add(file.getName().replaceFirst("\\.jar$", ".dex"));
            }
        }
        File dexOptDir = context.getDir("exopackage_dex_opt", 0);
        SystemClassLoaderAdder.installDexJars(context.getClassLoader(), dexOptDir, dexJars);
        File[] odexes = dexOptDir.listFiles();
        if (odexes != null) {
            for (File odex : odexes) {
                if (expectedOdexSet.contains(odex.getName()) || odex.delete()) continue;
                Log.w((String)TAG, (String)("Failed to delete stale odex: " + odex.getAbsolutePath()));
            }
        }
    }
}

